c     --------------------------------------------------------------------EXRES
      subroutine exres (disp,ndof,iele,cres,d0,icode,idat,iconv,fr,
     +ener,dissi,windo,lmdat,ekdat,bdat,enerb)
      implicit double precision (a-h, o-z)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /bacup/ nvec,imass,idead,iep0,ifalse(5)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
      common /crack/ rtn,ftol,icrack,ks,nlar,ncrk,ncel,mxk,ipd,ipor,ndt
      dimension disp(1),ndof(1),iele(5,1),cres(4,1),d0(4,1),icode(1),
     +idat(1),fr(1),edis(8),bmat(36),tres(24),dmat(6),windo(1),lmdat(1),
     +ekdat(1),bdat(36,1)
c
c.....This routine computes the total strains and stresses at each Gauss point
c     of the elements and takes average of the Gauss point strains to determine
c     the centroidal strains
c                                  Sudip S.B./February 20,1992/McGill
c     Modified for step crack propagation..........Sudip S.B./November 18,1992
c
      iconv=0
      nposib=0
      eden=0.d0
      call izero (dmat,12)
      call izero (fr,neq*2)
      ndata=4*numel
      call bakup (cres(1,1),ndata,-iep0,windo)
      disp(neq+1)=0.d0
      ener=0.d0
      enerb=0.d0
      dissi=0.d0
      do 500 n=1,numel
         ncode=icode(n)
         mat=iele(5,n)
c         read(nt8,rec=n) bmat
         call coprr (bdat(1,n),bmat,36)
         call disin (iele(1,n),disp,ndof,edis)
         jdat=-8
         kdat=-5
         do 200 i=1,4
            jdat=jdat+9
            kdat=kdat+6
            call strain (edis,tres(kdat),bmat(jdat),cres(i,n))
  200    continue
            call copr (d0(1,mat),dmat(1),4)
            dmat(5)=0.d0
            dmat(6)=0.d0
c.....   compute stresses and develop the restoring force vector
         call stress (tres,dmat)
         do 230 k=1,4
            ii=(k-1)*6+4
            jj=(k-1)*9+1
            call restor (tres(ii),fr,bmat(jj),bmat(jj+8),iele(1,n),ndof)
            call energy (tres(ii),tres(ii-3),bmat(jj+8),ener)
  230    continue
            do 240 j=4,6
               cres(j-3,n)=(tres(j)+tres(j+6)+tres(j+12)+tres(j+18))/4.0
  240       continue
  500 continue
c.....Add the restoring forces of the beam or lumped stiffness elements
      if (nbms .ne. 0) call beamf (disp,fr,nbms,lmdat,ekdat,enerb)
c
c      if (nposib .ne. 0) then
c         iconv=1
c         mat=iele(5,nposib)
c         call selec (ebak,iele(1,nposib),fr,ndatam,propma(1,mat),nck,
c     +   icode,idat(1),d0(1,mat),ndof,nposib,ep1,ep2,tt1,iface,
c     +   cres(1,nposib),dissi,ener,eden,bdat(1,nposib))
c      else
c         continue
c      endif
      ener=ener*0.5
      enerb=enerb*0.5
      dissi=dissi*0.5
c
      return
      end
c     --------------------------------------------------------------------EX_ES
      subroutine ex_es (disp,ndof,iele,cres,stressn,d0,icode,idat,iconv,
     +fr,ndatam,propma,iface,nck,ener,dissi,windo,lmdat,ekdat,bdat,porel
     +,coord,enerb)
      implicit double precision (a-h, o-z)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /bacup/ nvec,imass,idead,iep0,ifalse(5)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
      common /crack/ rtn,ftol,icrack,ks,nlar,ncrk,ncel,mxk,ipd,ipor,ndt
      dimension disp(1),ndof(1),iele(5,1),cres(4,1),stressn(4,1),d0(4,1)
     +,icode(1),idat(1),fr(1),propma(ndatam,1),iface(1),nck(1),edis(8),
     +bmat(36),tres(24),dmat(6),ebak(24),windo(1),lmdat(1),ekdat(1),
     +bdat(36,1),porel(1),coord(1)
c
c.....This routine computes the total strains and stresses at each Gauss point
c     of the elements and takes average of the Gauss point strains to determine
c     the centroidal strains
c                                  Sudip S.B./February 20,1992/McGill
c
      iconv=0
      nposib=0
      eden=0.d0
      call izero (dmat,12)
      call izero (fr,neq*2)
      ndata=4*numel
      call bakup (cres(1,1),ndata,-iep0,windo)
      disp(neq+1)=0.d0
      ener=0.d0
      enerb=0.d0
      dissi=0.d0
      do 500 n=1,numel
         ncode=icode(n)
         mat=iele(5,n)
c         read(nt8,rec=n) bmat
         call coprr (bdat(1,n),bmat,36)
         call disin (iele(1,n),disp,ndof,edis)
         jdat=-8
         kdat=-5
         do 200 i=1,4
            jdat=jdat+9
            kdat=kdat+6
            call strain (edis,tres(kdat),bmat(jdat),cres(i,n))
  200    continue
            call copr (d0(1,mat),dmat(1),4)
            dmat(5)=0.d0
            dmat(6)=0.d0
c.....   compute stresses and develop the restoring force vector
         call stress (tres,dmat)
         do 230 k=1,4
            ii=(k-1)*6+4
            jj=(k-1)*9+1
            call restor (tres(ii),fr,bmat(jj),bmat(jj+8),iele(1,n),ndof)
            call energy (tres(ii),tres(ii-3),bmat(jj+8),ener)
  230    continue
         do 240 j=4,6
            cres(j-3,n)=(tres(j)+tres(j+6)+tres(j+12)+tres(j+18))/4.0
  240    continue
	   do i=1,4
	      k=(i-1)*6+3
		  do j=1,3
			 stressn(j,iele(i,n))=stressn(j,iele(i,n))+tres(k+j)
	      end do
			 stressn(4,iele(i,n))=stressn(4,iele(i,n))+1
	   end do
  500 continue
	do i=1,numnp
	   do j=1,3
		  stressn(j,i)=stressn(j,i)/stressn(4,i)
	   end do
	end do
c.....Add the restoring forces of the beam or lumped stiffness elements
      if (nbms .ne. 0) call beamf (disp,fr,nbms,lmdat,ekdat,enerb)
  550 continue
      ener=ener*0.5
      enerb=enerb*0.5
      dissi=dissi*0.5
c
      return
      end
c     -------------------------------------------------------------------DISIN
      subroutine disin (iele,disp,ndof,edisp)
      implicit double precision (a-h,o-z)
      dimension iele(5),disp(1),ndof(3,1),edisp(2,4)
c.....Assembles the nodal displacements for each element
      do 100 i=1,4
         node=iele(i)
         edisp(1,i)=disp(ndof(1,node))
         edisp(2,i)=disp(ndof(2,node))
  100 continue
c
         return
         end
c     -------------------------------------------------------------------STRAIN
      subroutine strain (edisp,strin,bmat,eps0)
      implicit double precision (a-h,o-z)
      dimension edisp(2,4),strin(3),bmat(2,4)
c.....Computes total strains
      epx=-eps0
      epy=-eps0
      gxy=0.d0
      do 200 i=1,4
         epx=epx+bmat(1,i)*edisp(1,i)
         epy=epy+bmat(2,i)*edisp(2,i)
         gxy=gxy+bmat(1,i)*edisp(2,i)+bmat(2,i)*edisp(1,i)
  200 continue
c
      strin(1)=epx
      strin(2)=epy
      strin(3)=gxy
c
      return
      end
c     -------------------------------------------------------------------STRESS
      subroutine stress (tres,dmat)
      implicit double precision (a-h,o-z)
      dimension tres(24),dmat(6)
c.....computes stresses
      do 100 k=1,4
       kk=(k-1)*6+1
       tres(kk+3)=dmat(1)*tres(kk)+dmat(2)*tres(kk+1)+dmat(5)*tres(kk+2)
       tres(kk+4)=dmat(2)*tres(kk)+dmat(3)*tres(kk+1)+dmat(6)*tres(kk+2)
       tres(kk+5)=dmat(5)*tres(kk)+dmat(6)*tres(kk+1)+dmat(4)*tres(kk+2)
  100 continue
c      do 200 j=4,6
c         cres(j-3)=(tres(j)+tres(j+6)+tres(j+12)+tres(j+18))/4.d0
c  200 continue
c
      return
      end
c     -------------------------------------------------------------------AVRES
      subroutine avres (cres,tres)
      double precision cres(4),tres(24)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c.....Computes the average strain at the element centroid
      do 100 i=1,3
         cres(i)=(tres(i)+tres(i+6)+tres(i+12)+tres(i+18))/4.d0
  100    continue
c
      return
      end
c     -------------------------------------------------------------------ENERGY
      subroutine energy (stres,strin,xjac,ener)
      double precision stres(3),strin(3),xjac,ener
c
      do 100 i=1,3
         ener=ener+stres(i)*strin(i)*xjac
  100 continue
      return
      end
c     --------------------------------------------------------------------BEAMF
      subroutine beamf (disp,fr,nbms,lmdat,ekdat,enerb)
      implicit double precision (a-h,o-z)
      dimension disp(1),fr(1),lm(8),ek(6,6),lmdat(8,1),ekdat(64,1),
     +bprop(12),frce(6)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c     Computes the restoring forces in individual beam or lumped stiffness
c     elements
c
c      nn=numel+1
c      mm=numel+nbms
c      do 200 n=nn,mm
c         read (nsp,rec=n) lm,ek
       do 200 n=1,nbms
          call copyi (lm,lmdat(1,n),6)
          call coprr (ekdat(1,n),ek(1,1),36)
          call coprr (ekdat(37,n),bprop(1),12)
          do 100 j=1,6
             frce(j)=0
             do 100 i=1,6
                frce(j)=frce(j)+ek(i,j)*disp(lm(i))
  100     continue
          frce(1)=frce(1)-bprop(11)
          frce(2)=frce(2)-bprop(12)
          frce(4)=frce(4)+bprop(11)
          frce(5)=frce(5)+bprop(12)
          do 110 j=1,6
             jj=lm(j)
             fr(jj)=fr(jj)+frce(j)
             enerb=enerb+frce(j)*disp(jj)
  110     continue
          call coprr (frce(1),ekdat(49,n),6)
          af=frce(1)*bprop(9)+frce(2)*bprop(10)
          ekdat(55,n)=-af/bprop(1)
  200 continue
c
      return
      end
c     -------------------------------------------------------------------SUMBMS
      subroutine sumbms (time,ekdat,nbms)
      implicit double precision (a-h,o-z)
      dimension ekdat(64,1)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8(3),nt11,nt12(3)
c
c     Computes the restoring forces in individual beam or lumped stiffness
c     elements
c
      write (nt11,1001) time,(ekdat(55,n),n=1,nbms)
c
 1001 format (f8.5,200d12.6)
c
      return
      end
      subroutine viscs (velo,ndof,iele,cres,d0,icode,idat,bdat,bk,kpd)
c
      implicit double precision (a-h, o-z)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /bacup/ nvec,imass,idead,iep0,ifalse(5)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10(4),nt14
      common /crack/ rtn,ftol,icrack,ks,nlar,ncrk,ncel,mxk,ipd,ipor,ndt
      dimension velo(1),ndof(1),iele(5,1),cres(4,1),d0(4,1),icode(1),
     +idat(1),bdat(36,1),edis(8),bmat(36),tres(24),dmat(6)
c
c.....This routine computes the viscous stresses at each Gauss point
c     of the elements and takes average of these stresses to determine
c     the centroidal response
c                                  Sudip S.B./January 01,1995/Ecole Poly.
      call izero (dmat,12)
      call izero (cres(1,1),8*numel)
      velo(neq+1)=0.d0
      do 500 n=1,numel
         ncode=icode(n)
         mat=iele(5,n)
c
         fact=bk
         if (ncode .gt. 0  .and.  kpd .ne. 0) then
            if (kpd .lt. 0) then
               fact=0.d0
            else
               call xdmat (idat,dmat,n)
            endif
         else
            call copr (d0(1,mat),dmat(1),4)
            dmat(5)=0.d0
            dmat(6)=0.d0
         endif
         if (fact .eq. 0.d0) go to 500
c.....   compute viscous strains
         call coprr (bdat(1,n),bmat,36)
         call disin (iele(1,n),velo,ndof,edis)
         jdat=-8
         kdat=-5
         do 200 i=1,4
            jdat=jdat+9
            kdat=kdat+6
            call strain (edis,tres(kdat),bmat(jdat),cres(i,n))
  200    continue
         call stress (tres,dmat)
         fact=fact/4.0
         do 240 j=4,6
            cres(j-3,n)=(tres(j)+tres(j+6)+tres(j+12)+tres(j+18))*fact
  240    continue
c
  500 continue
c
      write (nt14) ((real(cres(i,j)),i=1,3),j=1,numel)
c
      return
      end
c     -------------------------------------------------------------------XDMAT
      subroutine xdmat (idat,dmat,iel)
      implicit double precision (a-h, o-z)
      dimension idat(1),dmat(6)
      common /crack/ rtn,ftol,icrack,ks,nlar,ncrk,ncel,mxk,ipd,ipor,ndt
c
c.....Find the [D] matrix of a crack element
c                                        Sudip S.B./January 1, 1995/Ecole Poly
      call copyr (dmat,idat(ldat+34),6)
c
      return
      end
